EXP = {};
LVL = {};
LVL2 = {};
LVLocal = {};

-- This table contains some values used on the Level's System.
LevelSystem = {
	Options = {
		IsEnabled = true, -- boolean expected (true / false).
	},
	Settings = {
		MaxLevel = 1000,
		ExpFactor = 525,
		DownScaling = 1,
	},
};

-- This function will save each EXP Level on the table "EXP".
-- The EXP per Level is automatically calculated.
local function SetExpPerLevel()
	local XP
	for i=1,LevelSystem.Settings.MaxLevel do
		XP = i * ( ( i / LevelSystem.Settings.DownScaling ) * LevelSystem.Settings.ExpFactor )
		table.insert(EXP,XP)
	end
end

-- This will run and set all the values on the table "EXP".
SetExpPerLevel()

-- Used specially when profiles arent been loaded yet.
function LevelSystemForLocalProfiles(p)
	-- Check first if the Level's System is enabled.
	if LevelSystem.Options.IsEnabled == false then
		return ""
	end

	local Profile = PROFILEMAN:GetLocalProfileFromIndex(p)
	local DancePoints = Profile:GetTotalDancePoints()
	local XP = DancePoints
	local LV
	
	for i = 1,LevelSystem.Settings.MaxLevel do
		if XP > EXP[i] then
			LV = i
		end
		if LV == nil then LV = 0 end
	end
	
	return tostring(LV)
end

function LevelSystemForLoadedProfiles(pn)
	-- Check first if the Level's System is enabled.
	if LevelSystem.Options.IsEnabled == false then
		return ""
	end
	
	local Profile = PROFILEMAN:GetProfile(pn)
	local DancePoints = Profile:GetTotalDancePoints()
	local XP = DancePoints
	local LV

	for i = 1,LevelSystem.Settings.MaxLevel do
		if XP > EXP[i] then
			LV = i
		end
		if LV == nil then LV = 0 end
	end
	
	return tostring(LV)
end

function EXPObtained(pn)
	-- Check first if the Level's System is enabled.
	if LevelSystem.Options.IsEnabled == false then
		return ""
	end
	return PROFILEMAN:GetProfile(pn):GetTotalDancePoints()
end

function NextLevel(pn)
	-- Check first if the Level's System is enabled.
	if LevelSystem.Options.IsEnabled == false then
		return ""
	end
	
	local Profile = PROFILEMAN:GetProfile(pn)
	local DancePoints = Profile:GetTotalDancePoints()
	local XP = DancePoints
	local NextEXP
	
	for i = 1,LevelSystem.Settings.MaxLevel do
		if XP < EXP[1] then
			NextEXP = EXP[1]
		end
		if XP > EXP[i] then
			NextEXP = EXP[i+1]
		end
		if NextEXP == LevelSystem.Settings.MaxLevel then
			NextEXP = "---"
		end
	end
	return NextEXP
end